#!/bin/sh
# Copyright (c) 2000-2013 Synology Inc. All rights reserved.

. /etc.defaults/rc.subr                 # for LSB definition and utilities
. /usr/syno/etc.defaults/rc.ssh.subr    # for SSH register key definition

RM="/bin/rm"
DataUpdate="/usr/syno/bin/syno_bkp_data_update"
Rsync="/usr/syno/bin/rsync"
RsyncPidFile="/var/run/rsyncd.pid"

StartSSHForRsync()
{
    ${SSHDUtils} --register ${ReferKeyRsync} ${ReferProcRsync}
    /sbin/start sshd 2>&1 >/dev/null
}

StopSSHForRsync()
{
    # Unregister rsync from ssh, and kill all relative process
    ${SSHDUtils} --unregister ${ReferKeyRsync}
}

StartRsyncDaemon()
{
    # Start rsyncd, it will write it pid into /var/log/rsyncd.pid
    if [ -x "$Rsync" ]; then
        $Rsync --daemon
    else
        echo "$Rsync is not executable."
    fi
}

StopRsyncDaemon()
{
    if [ -f "$RsyncPidFile" ]; then
        PROCESS_PID=`cat $RsyncPidFile`
        kill -9 $PROCESS_PID
        $RM $RsyncPidFile
    fi
}

StartDataUpdate()
{
    $DataUpdate &
}

case "$1" in
stop)
    StopRsyncDaemon
    StopSSHForRsync
    ;;
start)
    # if the number of sections in rsyncd.conf >=2, use rsyncd.conf (means user once modifed the file)
    NumSec=`/bin/grep -s "^[[:space:]]*\[.*\][[:space:]]*$" /etc/rsyncd.conf | wc -l`
    NumKeyRsyncConf=`/bin/grep -s "^use_rsyncd_conf" /etc/synoinfo.conf | wc -l`
    if [ $NumSec -ge 2 ] && [ $NumKeyRsyncConf -eq 0 ]; then
        echo "use_rsyncd_conf=\"yes\"" >> /etc/synoinfo.conf
    fi

    StartRsyncDaemon
    StartSSHForRsync
    StartDataUpdate
    ;;
restart)
    $0 stop
    sleep 1
    $0 start
    ;;
status)
    #FIXME!!! return slb status
    echo "Not implemnted now..."
    ;;
*)
    echo "usage: $0 { start | stop | restart | status}" >&2
    exit 1
    ;;
esac
